package ru.yandex.msearch.collector.docprocessor;

import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.Map;

import org.apache.lucene.util.StringHelper;
import ru.yandex.msearch.collector.FieldToIndex;
import ru.yandex.msearch.collector.YaDoc3;
import ru.yandex.msearch.collector.YaField;
import ru.yandex.search.json.fieldfunction.SumMapFunction;

public class MapExtractValueProcessor implements DocProcessor{
    private final String field;
    private final String outField;
    protected final String key;
    protected final int fieldIndex;
    protected final int outFieldIndex;

    public MapExtractValueProcessor(
        final String args,
        final FieldToIndex fieldToIndex)
        throws ParseException
    {
        if (args == null || args.isEmpty()) {
            throw new ParseException("Arguments required", 0);
        }
        int space = args.lastIndexOf(' ');
        if (space <= 0 || space + 1 == args.length()) {
            throw new ParseException(
                "No outfield specified. "
                    + "Arguments expected to be in form: "
                    + "field1,needle1(,needle2)* outfield. Was: "
                    + args,
                0);
        }
        int comma = args.indexOf(',');
        if (comma == -1 || comma > space) {
            throw new ParseException(
                "Empty or missing needles to search for. "
                    + "Arguments expected to be in form: "
                    + "field1,needle1(,needle2)* outfield. Was: "
                    + args,
                0);
        }
        field = StringHelper.intern(args.substring(0, comma));
        outField = StringHelper.intern(args.substring(space + 1));
        key = StringHelper.intern(args.substring(comma + 1, space));
        fieldIndex = fieldToIndex.indexFor(field);
        outFieldIndex = fieldToIndex.indexFor(outField);
    }

    protected long fetchValue(final YaField field) {
        String value = field.toString();
        long result = 0L;
        if (value != null) {
            Map<String, Long> map = new LinkedHashMap<>();
            try {
                SumMapFunction.parseMap(map, value);
            } catch (NumberFormatException nfe) {
            }

            result = map.getOrDefault(key, result);
        }

        return result;
    }

    @Override
    public void process(final YaDoc3 doc) {
        final YaField field = doc.getField(fieldIndex);
        doc.setField(outFieldIndex, new YaField.LongYaField(fetchValue(field)));
    }

    @Override
    public void apply(final ModuleFieldsAggregator aggregator) {
        aggregator.add(field, outField);
    }
}
