package ru.yandex.msearch.collector.docprocessor;

import java.text.ParseException;

import ru.yandex.msearch.collector.FieldToIndex;
import ru.yandex.msearch.collector.YaDoc3;
import ru.yandex.msearch.collector.YaField;

public class MinFieldDocProcessor extends ManyToOneDocProcessor {
    public MinFieldDocProcessor(
        final String args,
        final FieldToIndex fieldToIndex)
        throws ParseException
    {
        super(args, fieldToIndex);
    }

    @Override
    public void process(final YaDoc3 doc) {
        YaField result = null;
        int pos = 0;
        while (pos < fieldIndexes.length && result == null) {
            result = doc.getField(fieldIndexes[pos++]);
        }
        while (pos < fieldIndexes.length) {
            YaField field = doc.getField(fieldIndexes[pos++]);
            if (field != null && result.compareTo(field) > 0) {
                result = field;
            }
        }
        if (result != null) {
            doc.setField(outFieldIndex, result);
        }
    }
}

