package ru.yandex.msearch.collector.docprocessor;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class ModuleFieldsAggregator {
    private final LinkedHashSet<String> loadFields;
    private final LinkedHashSet<String> outFields;

    public ModuleFieldsAggregator() {
        this.loadFields = new LinkedHashSet<>();
        this.outFields = new LinkedHashSet<>();
    }

    public void add(final String loadField, final String outField) {
        if (!outFields.contains(loadField)) {
            loadFields.add(loadField);
        }

        outFields.add(outField);
    }

    public void add(
        final Set<String> loadFields,
        final Set<String> outFields)
    {
        for (String loadField: loadFields) {
            if (!this.outFields.contains(loadField)) {
                this.loadFields.add(loadField);
            }
        }

        this.outFields.addAll(outFields);
    }

    public void addWithSingleOut(
        final String outField,
        final Set<String> loadFields)
    {
        for (String loadField: loadFields) {
            if (!this.outFields.contains(loadField)) {
                this.loadFields.add(loadField);
            }
        }

        this.outFields.add(outField);
    }

    public void addWithSingleOut(
        final String outField,
        final String... loadFields)
    {
        for (String loadField: loadFields) {
            if (!this.outFields.contains(loadField)) {
                this.loadFields.add(loadField);
            }
        }

        outFields.add(outField);
    }

    public void addWithSingleLoad(
        final String loadField,
        final String... outFields)
    {
        if (!this.outFields.contains(loadField)) {
            loadFields.add(loadField);
        }

        Collections.addAll(this.outFields, outFields);
    }

    public Set<String> outFields() {
        return outFields;
    }

    public Set<String> loadFields() {
        return loadFields;
    }
}
