package ru.yandex.msearch.collector.docprocessor;

import java.text.ParseException;

import ru.yandex.msearch.collector.FieldToIndex;
import ru.yandex.msearch.collector.MultiYaField;
import ru.yandex.msearch.collector.YaDoc3;
import ru.yandex.msearch.collector.YaField;

public class MultiFieldDocProcessor extends ManyToOneDocProcessor {
    public MultiFieldDocProcessor(
        final String args,
        final FieldToIndex fieldToIndex)
        throws ParseException
    {
        super(args, fieldToIndex);
    }

    @Override
    public void process(final YaDoc3 doc) {
        YaField[] fields = new YaField[fieldIndexes.length];
        for (int i = 0; i < fieldIndexes.length; ++i) {
            fields[i] = doc.getField(fieldIndexes[i]);
        }
        doc.setField(outFieldIndex, new MultiYaField(fields));
    }
}

