package ru.yandex.msearch.collector.docprocessor;

import java.text.ParseException;

import org.apache.lucene.util.StringHelper;

import ru.yandex.msearch.collector.FieldToIndex;
import ru.yandex.msearch.collector.YaDoc3;
import ru.yandex.msearch.collector.YaField;

public class PolyDocProcessor implements DocProcessor {
    private final String[] fields;
    private final String outField;
    protected final int[] fieldIndexes;
    protected final int outFieldIndex;
    protected final float[] ks;

    public PolyDocProcessor(
        final String args,
        final FieldToIndex fieldToIndex)
        throws ParseException
    {
        if (args == null || args.isEmpty()) {
            throw new ParseException("Arguments required", 0);
        }
        int space = args.lastIndexOf(' ');
        if (space <= 0 || space + 1 == args.length()) {
            throw new ParseException(
                "No outfield specified. "
                + "Arguments expected to be in form: "
                + "field1,needle1(,needle2)* outfield. Was: "
                + args,
                0);
        }
        int comma = args.indexOf(',');
        if (comma == -1 || comma > space) {
            throw new ParseException(
                "Empty or missing K for field. "
                + "Arguments expected to be in form: "
                + "field1,k1(,field2,k2)* outfield. Was: "
                + args,
                0);
        }
        outField = StringHelper.intern(args.substring(space + 1));
        outFieldIndex = fieldToIndex.indexFor(outField);
        final String[] cols = args.substring(0, space).split(",");
        if (cols.length % 2 != 0) {
            throw new ParseException(
                "Empty or missing K for some field. "
                + "Arguments expected to be in form: "
                + "field1,k1(,field2,k2)* outfield. Was: "
                + args,
                0);
        }
        fields = new String[cols.length >> 1];
        fieldIndexes = new int[fields.length];
        ks = new float[fields.length];
        for (int i = 0, j = 0; i < cols.length; i += 2, ++j) {
            String field = StringHelper.intern(cols[i]);
            fields[j] = field;
            fieldIndexes[j] = fieldToIndex.indexFor(field);
            ks[j] = Float.parseFloat(cols[i + 1]);
        }
    }

    @Override
    public void process(final YaDoc3 doc) {
        float result = 0;
        for (int i = 0; i < fieldIndexes.length; i++) {
            YaField yf = doc.getField(fieldIndexes[i]);
            float value;
            if (yf != null) {
                value = yf.floatValue();
            } else {
                value = 0;
            }
            result += ks[i] * value;
        }
        doc.setField(outFieldIndex, new YaField.FloatYaField(result));
    }

    @Override
    public void apply(final ModuleFieldsAggregator aggregator) {
        aggregator.addWithSingleOut(outField, fields);
    }
}

