package ru.yandex.msearch.collector.docprocessor;

import java.text.ParseException;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import ru.yandex.msearch.collector.FieldToIndex;
import ru.yandex.msearch.collector.YaDoc3;
import ru.yandex.msearch.collector.YaField;

public class RegexContainsDocProcessor extends ContainsDocProcessor {
    protected Pattern[] patterns;

    public RegexContainsDocProcessor(
        final String args,
        final FieldToIndex fieldToIndex)
        throws ParseException
    {
        this(args, fieldToIndex, false);
    }

    public RegexContainsDocProcessor(
        final String args,
        final FieldToIndex fieldToIndex,
        final boolean any)
        throws ParseException
    {
        super(args, fieldToIndex, any);
        patterns = new Pattern[needles.length];
        int i = 0;
        for (final String needle : needles) {
            patterns[i++] = Pattern.compile(needle);
        }
    }

    @Override
    public void process(final YaDoc3 doc) {
        final YaField field = doc.getField(fieldIndex);
        int found = 0;
        if (field != null) {
            final String value = field.toString();
            for (final Pattern pattern : patterns) {
                final Matcher matcher = pattern.matcher(value);
                while (matcher.find()) {
                    found ++;
                    if (any) {
                        break;
                    }
                }
                if (found > 0 && any) {
                    break;
                }
            }
        }
        doc.setField(outFieldIndex, new YaField.IntegerYaField(found));
    }
}

