package ru.yandex.msearch.collector.docprocessor;

import org.apache.lucene.util.StringHelper;

import ru.yandex.msearch.collector.FieldToIndex;
import ru.yandex.msearch.collector.YaDoc3;
import ru.yandex.msearch.collector.YaField;

import ru.yandex.util.string.StringUtils;

import java.text.ParseException;

public class ReplaceAllDocProcessor implements DocProcessor {
    private final static String ARGUMENTS_EXPECTED_MSG =
        "Arguments expected to be in form: field,regex,replacement outfield."
        + " Was: ";

    private final String field;
    protected final int fieldIndex;
    private final String outField;
    protected final int outFieldIndex;
    protected final String regex;
    protected final String replacement;

    public ReplaceAllDocProcessor(
        final String args,
        final FieldToIndex fieldToIndex)
        throws ParseException
    {
        if (args == null || args.isEmpty()) {
            throw new ParseException("Arguments required", 0);
        }
        int space = args.lastIndexOf(' ');
        if (space <= 0 || space + 1 == args.length()) {
            throw new ParseException(
                "No outfield specified. " + ARGUMENTS_EXPECTED_MSG + args,
                0);
        }
        int comma = args.indexOf(',');
        int secondComma = args.indexOf(',', comma + 1);
        if (comma == -1 || comma > space
            || secondComma == -1 || secondComma > space)
        {
            throw new ParseException(
                "Empty or missing needles to search for. "
                + ARGUMENTS_EXPECTED_MSG + args,
                0);
        }
        field = StringHelper.intern(args.substring(0, comma));
        fieldIndex = fieldToIndex.indexFor(field);
        regex = StringHelper.intern(args.substring(comma + 1, secondComma));
        replacement = StringHelper.intern(args.substring(secondComma + 1, space));
        outField = StringHelper.intern(args.substring(space + 1));
        outFieldIndex = fieldToIndex.indexFor(outField);

        if (regex.isEmpty()) {
            throw new ParseException("Empty regexp", 0);
        }
    }

    @Override
    public void process(final YaDoc3 doc) {
        final YaField field = doc.getField(fieldIndex);
        if (field != null) {
            final String value = field.toString();
            String result = value.replaceAll(regex, replacement);
            doc.setField(
                outFieldIndex,
                new YaField.StringYaField(StringUtils.getUtf8Bytes(result)));
        }
    }

    @Override
    public void apply(final ModuleFieldsAggregator aggregator) {
        aggregator.add(field, outField);
    }
}
