package ru.yandex.msearch.collector.docprocessor;

import java.text.ParseException;

import ru.yandex.msearch.collector.FieldToIndex;
import ru.yandex.msearch.collector.YaDoc3;
import ru.yandex.msearch.collector.YaField;

public class RoundDocProcessor extends UnaryOperatorDocProcessor {
    public RoundDocProcessor(
        final String args,
        final FieldToIndex fieldToIndex)
        throws ParseException
    {
        super(args, fieldToIndex);
    }

    @Override
    public void process(final YaDoc3 doc) {
        YaField field = doc.getField(fieldIndex);
        if (field != null) {
            if (field.type() == YaField.FieldType.LONG) {
                if (outFieldIndex != fieldIndex) {
                    doc.setField(outFieldIndex, field);
                }
            } else {
                doc.setField(
                    outFieldIndex,
                    new YaField.LongYaField(Math.round(field.floatValue())));
            }
        }
    }
}

