package ru.yandex.msearch.collector.docprocessor;

import java.text.ParseException;

import org.apache.lucene.util.BytesRef;

import ru.yandex.msearch.collector.FieldToIndex;
import ru.yandex.msearch.collector.YaDoc3;
import ru.yandex.msearch.collector.YaField;

import ru.yandex.util.string.StringUtils;

public class ToStringDocProcessor extends UnaryOperatorDocProcessor {
    public ToStringDocProcessor(
        final String args,
        final FieldToIndex fieldToIndex)
        throws ParseException
    {
        super(args, fieldToIndex);
    }

    @Override
    public void process(final YaDoc3 doc) {
        YaField field = doc.getField(fieldIndex);
        if (field != null) {
            if (field.type() == YaField.FieldType.STRING) {
                if (outFieldIndex != fieldIndex) {
                    doc.setField(outFieldIndex, field);
                }
            } else {
                doc.setField(
                    outFieldIndex,
                    YaField.FieldType.STRING.create(
                        StringUtils.getUtf8Bytes(field.toString())));
            }
        }
    }
}

