package ru.yandex.msearch.collector.docprocessor;

import java.text.ParseException;

import java.util.Collections;
import java.util.Set;

import ru.yandex.msearch.collector.FieldToIndex;
import ru.yandex.msearch.collector.YaDoc3;
import ru.yandex.msearch.collector.YaField;

public abstract class UnaryNonNullOperatorDocProcessor
    extends UnaryOperatorDocProcessor
{
    public UnaryNonNullOperatorDocProcessor(
        final String args,
        final FieldToIndex fieldToIndex)
        throws ParseException
    {
        super(args, fieldToIndex);
    }

    protected abstract YaField process(final YaField field);

    @Override
    public void process(final YaDoc3 doc) {
        YaField field = doc.getField(fieldIndex);
        if (field != null) {
            doc.setField(outFieldIndex, process(field));
        }
    }
}

