package ru.yandex.msearch.collector.docprocessor;

import java.text.ParseException;

import org.apache.lucene.util.StringHelper;

import ru.yandex.msearch.collector.FieldToIndex;

public abstract class UnaryOperatorDocProcessor implements DocProcessor {
    private final String field;
    private final String outField;
    protected final int fieldIndex;
    protected final int outFieldIndex;

    public UnaryOperatorDocProcessor(
        final String args,
        final FieldToIndex fieldToIndex)
        throws ParseException
    {
        if (args == null || args.isEmpty()) {
            throw new ParseException("Arguments required", 0);
        }
        String field;
        String outField;
        int space = args.indexOf(' ');
        if (space == -1) {
            field = args;
            outField = args;
        } else {
            field = args.substring(0, space);
            outField = args.substring(space + 1);
        }
        this.field = StringHelper.intern(field);
        this.outField = StringHelper.intern(outField);
        fieldIndex = fieldToIndex.indexFor(this.field);
        outFieldIndex = fieldToIndex.indexFor(this.outField);
    }

    @Override
    public void apply(final ModuleFieldsAggregator aggregator) {
        aggregator.add(field, outField);
    }
}

