package ru.yandex.msearch.collector.docprocessor;

import java.util.LinkedHashSet;
import java.util.Set;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.Version;

import ru.yandex.msearch.Config;
import ru.yandex.msearch.FieldConfig;
import ru.yandex.msearch.config.DatabaseConfig;
import ru.yandex.queryParser.YandexQueryParser;

public class YandexKeepFieldsQueryParser extends YandexQueryParser {
    private final Set<String> fields;
    public YandexKeepFieldsQueryParser(
        final Version version,
        final String field,
        final Analyzer analyzer,
        final DatabaseConfig config)
    {
        super(version, field, analyzer, config);
        fields = new LinkedHashSet<>();
    }


    @Override
    protected Query getFieldQuery(
        final String field,
        final String configField,
        final String text,
        final boolean quoted) throws ParseException
    {
        Query res =
            super.getFieldQuery(field, configField, text, quoted);
        String name = StringHelper.intern(configField);
        FieldConfig fieldConfig = config.fieldConfig(name);
        if (fieldConfig == null) {
            return res;
        }

        fields.add(name);
        return res;
    }

    public Set<String> fields() {
        return fields;
    }

    public void clearFields() {
        fields.clear();;
    }

    @Override
    protected Query getPrefixQuery(final String field, final String termStr) throws ParseException {
        Query res = super.getPrefixQuery(field, termStr);
        String name = StringHelper.intern(field);
        FieldConfig fieldConfig = config.fieldConfig(name);
        if (fieldConfig == null) {
            return res;
        }
        fields.add(field);
        return res;
    }
}
