package ru.yandex.msearch.collector.group;

import ru.yandex.function.GenericBiFunction;

import ru.yandex.msearch.collector.FieldToIndex;

public enum GroupFuncFactory
    implements GenericBiFunction<
        String,
        FieldToIndex,
        GroupFunc,
        RuntimeException>
{
    INSTANCE;

    @Override
    public GroupFunc apply(
        final String params,
        final FieldToIndex fieldToIndex)
    {
        if (params.isEmpty()) {
            return NullGroupFunc.INSTANCE;
        }
        int startBrace = params.indexOf('(');
        if (startBrace == -1) {
            return new SimpleGroupFunc(params, fieldToIndex);
        }
        String funcName = params.substring(0, startBrace);
        int endBrace = params.lastIndexOf(')');
        if (endBrace == -1) {
            endBrace = params.length();
        }
        String args = params.substring(startBrace + 1, endBrace);
        switch (funcName) {
            case "multi":
                return new MultiFieldGroupFunc(args, fieldToIndex);
            default:
                return new SimpleGroupFunc(params, fieldToIndex);
        }
    }
}

