package ru.yandex.msearch.collector.group;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

import org.apache.lucene.util.StringHelper;

import ru.yandex.msearch.collector.FieldToIndex;
import ru.yandex.msearch.collector.MultiYaField;
import ru.yandex.msearch.collector.YaDoc3;
import ru.yandex.msearch.collector.YaField;

public class MultiFieldGroupFunc implements GroupFunc {
    private final String[] fields;
    private final int[] fieldIndexes;

    public MultiFieldGroupFunc(
        final String params,
        final FieldToIndex fieldToIndex)
    {
        String[] fields = params.split(",");
        this.fields = new String[fields.length];
        fieldIndexes = new int[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            String field = StringHelper.intern(fields[i]);
            this.fields[i] = field;
            fieldIndexes[i] = fieldToIndex.indexFor(field);
        }
    }

    public YaField group(final YaDoc3 doc) {
        YaField[] yaFields = new YaField[fieldIndexes.length];
        for (int i = 0; i < fieldIndexes.length; ++i) {
            yaFields[i] = doc.getField(fieldIndexes[i]);
        }
        return new MultiYaField(yaFields);
    }

    public Set<String> loadFields() {
        return new HashSet<>(Arrays.asList(fields));
    }

    @Override
    public String toString() {
        return "MultiFieldGroupFunc" + Arrays.toString(fields);
    }
}

