package ru.yandex.msearch.collector.group;

import java.util.Collections;
import java.util.Set;

import org.apache.lucene.util.StringHelper;

import ru.yandex.msearch.collector.FieldToIndex;
import ru.yandex.msearch.collector.YaDoc3;
import ru.yandex.msearch.collector.YaField;

public class SimpleGroupFunc implements GroupFunc {
    private final String field;
    private final int fieldIndex;

    public SimpleGroupFunc(
        final String field,
        final FieldToIndex fieldToIndex)
    {
        this.field = StringHelper.intern(field);
        fieldIndex = fieldToIndex.indexFor(this.field);
    }

    @Override
    public YaField group(final YaDoc3 doc) {
        return doc.getField(fieldIndex);
    }

    @Override
    public Set<String> loadFields() {
        return Collections.singleton(field);
    }

    @Override
    public String toString() {
        return "SimpleGroupFunc(" + field + ')';
    }
}

