package ru.yandex.msearch.collector.outergroup;

import java.io.File;
import java.io.IOException;

import java.util.List;

import java.util.logging.Logger;

import ru.yandex.function.GenericBiFunction;

import ru.yandex.msearch.collector.FieldToIndex;

public class OuterGroupFunctionFactory
    implements GenericBiFunction<
        String,
        FieldToIndex,
        OuterGroupFunction,
        RuntimeException>
{
    private final File xurlsRegexFile;
    private volatile List<XURLSOuterDeduplicator.Rule> rules;
    private final Logger logger;

    public OuterGroupFunctionFactory(
        final File xurlsRegexFile,
        final Logger logger)
        throws IOException
    {
        this.xurlsRegexFile = xurlsRegexFile;
        this.logger = logger;
        reloadRules(logger);
    }

    public void reloadRules(final Logger logger) throws IOException {
        rules = XURLSOuterDeduplicator.loadPatterns(xurlsRegexFile, logger);
    }

    @Override
    public OuterGroupFunction apply(
        final String name,
        final FieldToIndex fieldToIndex)
    {
        if (name.equalsIgnoreCase("x_urls")) {
            return new XURLSOuterDeduplicator(
                rules,
                "x_urls",
                fieldToIndex,
                logger);
        } else if (name.startsWith("deduplicate:")) {
            return new XURLSOuterDeduplicator(
                rules,
                name.substring("deduplicate:".length()),
                fieldToIndex,
                false,
                logger);
        } else {
            return new SimpleOuterDeduplicator(name, fieldToIndex);
        }
    }
}

