package ru.yandex.msearch.collector.outergroup;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import org.apache.lucene.util.StringHelper;

import ru.yandex.msearch.collector.FieldToIndex;
import ru.yandex.msearch.collector.YaDoc3;
import ru.yandex.msearch.collector.YaField;

public class SimpleOuterDeduplicator implements OuterGroupFunction {
    private final Set<String> deduplicator = new HashSet<>();
    private final String fieldName;
    private final int fieldIndex;

    public SimpleOuterDeduplicator(
        final String fieldName,
        final FieldToIndex fieldToIndex)
    {
	this.fieldName = StringHelper.intern(fieldName);
        fieldIndex = fieldToIndex.indexFor(this.fieldName);
    }

    @Override
    public boolean modifyAndCheckDuplicated(final YaDoc3 document) {
	YaField f = document.getField(fieldIndex);
	if (f != null) {
            return !deduplicator.add(f.toString());
        }
	return false;
    }

    @Override
    public Set<String> loadFields() {
	return Collections.singleton(fieldName);
    }
}
