package ru.yandex.msearch.collector.postfilter;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.List;

import ru.yandex.msearch.collector.YaDoc3;

public class CompositePostFilter implements PostFilter {
    private final PostFilter[] filters;

    private CompositePostFilter(final List<PostFilter> filters) {
        this.filters = filters.toArray(new PostFilter[filters.size()]);
    }

    @Override
    public Set<String> loadFields() {
        Set<String> loadFields = new HashSet<>();
        for (PostFilter filter: filters) {
            loadFields.addAll(filter.loadFields());
        }
        return loadFields;
    }

    @Override
    public boolean test(final YaDoc3 doc) {
        for (PostFilter filter: filters) {
            if (!filter.test(doc)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public String toString() {
        return Arrays.toString(filters);
    }

    public static PostFilter create(final List<PostFilter> filters) {
        switch (filters.size()) {
            case 0:
                return NullPostFilter.INSTANCE;
            case 1:
                return filters.get(0);
            default:
                return new CompositePostFilter(filters);
        }
    }
}

