package ru.yandex.msearch.collector.postfilter;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;

import org.apache.lucene.util.StringHelper;

import ru.yandex.msearch.collector.FieldToIndex;
import ru.yandex.msearch.collector.YaDoc3;
import ru.yandex.msearch.collector.YaField;
import ru.yandex.util.string.StringUtils;

public class InSetFieldsFilter implements PostFilter {
    private final String field;
    private final int fieldIndex;
    private final Set<String> fields;
    private final Set<String> values;

    public InSetFieldsFilter(
        final String field,
        final FieldToIndex fieldToIndex,
        final String... values)
    {
        this.field = StringHelper.intern(field);
        fieldIndex = fieldToIndex.indexFor(this.field);
        fields = Collections.singleton(this.field);
        this.values = new HashSet<>(values.length << 1);
        for (String value: values) {
            this.values.add(value);
        }
    }

    @Override
    public Set<String> loadFields() {
        return fields;
    }

    @Override
    public boolean test(final YaDoc3 doc) {
        YaField field = doc.getField(fieldIndex);
        if (field == null) {
            return false;
        } else {
            return values.contains(field.toString());
        }
    }

    @Override
    public String toString() {
        return StringUtils.join(values, ',', field + " in ", "");
    }
}

