package ru.yandex.msearch.collector.postfilter;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;

import org.apache.lucene.util.StringHelper;

import ru.yandex.msearch.collector.FieldToIndex;
import ru.yandex.msearch.collector.YaDoc3;
import ru.yandex.msearch.collector.YaField;
import ru.yandex.util.string.StringUtils;

public class NotEqualFieldsFilter implements PostFilter {
    private final String field1;
    private final String field2;
    private final int field1Index;
    private final int field2Index;
    private final Set<String> fields;

    public NotEqualFieldsFilter(
        final String field1,
        final String field2,
        final FieldToIndex fieldToIndex)
    {
        this.field1 = StringHelper.intern(field1);
        this.field2 = StringHelper.intern(field2);
        field1Index = fieldToIndex.indexFor(this.field1);
        field2Index = fieldToIndex.indexFor(this.field2);
        fields = new HashSet<>(3);
        fields.add(this.field1);
        fields.add(this.field2);
    }

    @Override
    public Set<String> loadFields() {
        return fields;
    }

    @Override
    public boolean test(final YaDoc3 doc) {
        YaField field1 = doc.getField(field1Index);
        YaField field2 = doc.getField(field2Index);
        if (field1 == null) {
            // At least one field is not null
            // This means that fields is not equals (but present)
            return field2 != null;
        } else {
            return !field1.equals(field2);
        }
    }

    @Override
    public String toString() {
        return StringUtils.concat(field1, " notequals ", field2);
    }
}

