package ru.yandex.msearch.collector.postfilter;

import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;

import org.apache.lucene.util.StringHelper;

import ru.yandex.msearch.collector.FieldToIndex;
import ru.yandex.msearch.collector.YaDoc3;
import ru.yandex.msearch.collector.YaField;

public class SimplePostFilter implements PostFilter {
    private final String field;
    private final Predicate<YaField> predicate;
    private final int fieldIndex;

    public SimplePostFilter(
        final String field,
        final Predicate<YaField> predicate,
        final FieldToIndex fieldToIndex)
    {
        this.field = StringHelper.intern(field);
        this.predicate = predicate;
        fieldIndex = fieldToIndex.indexFor(this.field);
    }

    @Override
    public Set<String> loadFields() {
        return Collections.singleton(field);
    }

    @Override
    public boolean test(final YaDoc3 doc) {
        return predicate.test(doc.getField(fieldIndex));
    }

    @Override
    public String toString() {
        return field + ' ' + predicate;
    }
}

