package ru.yandex.msearch.collector.postfilter;

import java.util.function.DoublePredicate;
import java.util.function.Predicate;

import ru.yandex.msearch.collector.YaField;

public class YaFieldToFloatPredicate implements Predicate<YaField> {
    private final DoublePredicate predicate;

    public YaFieldToFloatPredicate(final DoublePredicate predicate) {
        this.predicate = predicate;
    }

    @Override
    public boolean test(final YaField field) {
        if (field == null) {
            return false;
        } else {
            return predicate.test(field.floatValue());
        }
    }

    @Override
    public String toString() {
        return predicate.toString();
    }
}

