package ru.yandex.msearch.collector.postfilter;

import java.util.function.LongPredicate;
import java.util.function.Predicate;

import ru.yandex.msearch.collector.YaField;

public class YaFieldToLongPredicate implements Predicate<YaField> {
    private final LongPredicate predicate;

    public YaFieldToLongPredicate(final LongPredicate predicate) {
        this.predicate = predicate;
    }

    @Override
    public boolean test(final YaField field) {
        if (field == null) {
            return false;
        } else {
            return predicate.test(field.longValue());
        }
    }

    @Override
    public String toString() {
        return predicate.toString();
    }
}

