package ru.yandex.msearch.collector.sort;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

import org.apache.lucene.util.StringHelper;

import ru.yandex.msearch.collector.DescendingYaField;
import ru.yandex.msearch.collector.FieldToIndex;
import ru.yandex.msearch.collector.MultiYaField;
import ru.yandex.msearch.collector.YaDoc3;
import ru.yandex.msearch.collector.YaField;

public class MultiFieldSortFunc implements SortFunc {
    private final String[] fields;
    private final int[] fieldIndexes;
    private final boolean[] fieldsOrder;

    public MultiFieldSortFunc(
        final String params,
        final FieldToIndex fieldToIndex)
    {
        fields = params.split(",");
        fieldIndexes = new int[fields.length];
        fieldsOrder = new boolean[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i].trim();
            int space = field.indexOf(' ');
            if (space != -1) {
                String order = field.substring(space + 1).toLowerCase();
                if (order.equals("desc")) {
                    fieldsOrder[i] = false;
                } else {
                    //TODO should throw an ParseException on invalid order flag
                    // if( order.equals( "asc" )
                    fieldsOrder[i] = true;
                }
                field = StringHelper.intern(field.substring(0, space));
            } else {
                fieldsOrder[i] = true;
                field = StringHelper.intern(field);
            }
            fields[i] = field;
            fieldIndexes[i] = fieldToIndex.indexFor(field);
        }
    }

    public YaField sortField(final YaDoc3 doc) {
        YaField[] yaFields = new YaField[fieldIndexes.length];
        for (int i = 0; i < fieldIndexes.length; i++) {
            yaFields[i] = doc.getField(fieldIndexes[i]);
            if (!fieldsOrder[i]) {
                yaFields[i] = new DescendingYaField(yaFields[i]);
            }
        }
        return new MultiYaField(yaFields);
    }

    public Set<String> loadFields() {
        return new HashSet<>(Arrays.asList(fields));
    }

    @Override
    public String toString() {
        return "MultiFieldSortFunc" + Arrays.toString(fields)
            + '/' + Arrays.toString(fieldsOrder);
    }
}

