package ru.yandex.msearch.collector.sort;

import java.util.Collections;
import java.util.Set;

import org.apache.lucene.util.StringHelper;

import ru.yandex.msearch.collector.FieldToIndex;
import ru.yandex.msearch.collector.YaDoc3;
import ru.yandex.msearch.collector.YaField;

public class SimpleSortFunc implements SortFunc {
    private final String field;
    private final int fieldIndex;

    public SimpleSortFunc(
        final String field,
        final FieldToIndex fieldToIndex)
    {
        this.field = StringHelper.intern(field);
        fieldIndex = fieldToIndex.indexFor(this.field);
    }

    public YaField sortField(final YaDoc3 doc) {
        return doc.getField(fieldIndex);
    }

    public Set<String> loadFields() {
        return Collections.singleton(field);
    }

    @Override
    public String toString() {
        return "SimpleSortFunc(" + field + ")";
    }
}

