package ru.yandex.msearch.collector.sort;

import ru.yandex.function.GenericBiFunction;

import ru.yandex.msearch.collector.FieldToIndex;

public enum SortFuncFactory
    implements GenericBiFunction<
        String,
        FieldToIndex,
        SortFunc,
        RuntimeException>
{
    INSTANCE;

    @Override
    public SortFunc apply(
        final String params,
        final FieldToIndex fieldToIndex)
    {
        if (params.isEmpty()) {
            return NullSortFunc.INSTANCE;
        }
        int startBrace = params.indexOf('(');
        if (startBrace == -1) {
            return new SimpleSortFunc(params, fieldToIndex);
        }
        String funcName = params.substring(0, startBrace);
        int endBrace = params.lastIndexOf(')');
        if (endBrace == -1) {
            endBrace = params.length();
        }
        String args = params.substring(startBrace + 1, endBrace);
        if (funcName.equals("multi")) {
            return new MultiFieldSortFunc(args, fieldToIndex);
        }
        return new SimpleSortFunc(params, fieldToIndex);
    }
}

