package ru.yandex.msearch.config;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.lucene.queryParser.QueryParser;

import ru.yandex.collection.PatternMap;
import ru.yandex.http.util.request.RequestInfo;
import ru.yandex.msearch.FieldConfig;
import ru.yandex.msearch.FieldsConfig;
import ru.yandex.msearch.QueueShard;
import ru.yandex.msearch.collector.docprocessor.DocProcessorFactory;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.search.prefix.PrefixParser;
import ru.yandex.stater.RequestsStater;
import ru.yandex.stater.SimpleHistogramMetric;
import ru.yandex.stater.StaterConfigBuilder;

public interface DatabaseConfig {
    Set<String> services();

    String name();

    int yandexCodecCompressorLevel();

    SimpleHistogramMetric indexLagHistogram();

    DocProcessorFactory docProcessorFactory();

    boolean syncSearcherDefault();

    boolean earlyInterruptDefault();

    boolean oDirectWrite();

    boolean warmOnInit();

    // TODO multidb support
    int partFlushThreshold();

    boolean updatePrefixActivity();

    long prefixActivityTimeout();

    // TODO multidb support
    //File ssdCachePath();

    //long ssdCacheSize();

    int segmentsPerTier();

    long maxSegmentSize();

    int commonTaskExecutorThreads();

    boolean returnMaxQueueId();

    boolean fakeQueueIdsPush();

    String defaultFieldCodec();

    boolean inMemoryFieldsIndex();

    int fieldIndexReadBufferSize();

    boolean autoPruning();

    boolean checkCopyness();

    // TODO multidb support
    boolean useFastCommitCodec();

    boolean queueIdServiceFallback();

    boolean logParsedRequest();

    // TODO multidb support in SumLimiter in Indexer Server
    int indexThreads();

    int partsExecutorThreadCount();

    int warmerThreads();

    long maxMemDocs();

    int limitIndexRequests();

    // TODO multidb support in MemoryIndex
    long maxPartJournalSize();

    int maxMergeThreads();

    // TODO multidb support in IndexGetter
    double reclaimDeletesWeight();

    double autoExpungePct();

    int indexDivisor();

    int shards();

    default boolean kosherShards() {
        return QueueShard.SHARDS_MAGIC % shards() == 0;
    }

    // TODO multidb support in AbstractJsonMessage
    int inMemoryParsingLimit();

    // TODO multidb support - common rate limit ?
    int indexCopyRateLimitMb();

    // TODO multidb support in multiple places
    boolean useJournal();

    // TODO multidb support in PkPart
    boolean autoFixIndex();

    // TODO multidb support in NewSearchRequest
    boolean lowercaseExpandedTerms();

    File indexPath();

    // TODO multidb support in multiple places
    PrefixParser prefixParser();

    // TODO multidb support in multiple places
    PrefixParser indexPrefixParser();

    // TODO multidb support in NewSearchRequest
    QueryParser.Operator defaultOperator();

    Set<String> primaryKey();

    int memoryCodecCompressorLevel();

    int yandexTermsWriterBlockSize();

    int yandexPostingsWriterBlockSize();

    // TODO multidb support in multiple places
    int yandexFieldsWriterBufferSize();

    Set<String> yandexCodecGroupFields();

    // TODO multidb support in multiple places
    boolean primaryKeyPartCacheDocuments();

    // TODO multidb support in PrimaryKey
    boolean prefixedPrimaryKey();

    //long parallelDocsSize();

    // TODO multidb support in IndexGetter
    boolean copyIndexUpdateQueueIdsOnEmptyDump();

    void reloadDynamicConfig(String name, String configStr) throws ConfigException, IOException;

    FieldsConfig fieldsConfig();

    default FieldConfig fieldConfig(final String field) {
        return fieldsConfig().fields().get(field);
    }

    default FieldConfig fieldConfigFast(final String field) {
        return fieldsConfig().fieldsFast().get(field);
    }

    default Set<String> knownFields() {
        return Collections.unmodifiableSet(fieldsConfig().fields().keySet());
    }

    default Set<String> storedFields() {
        return fieldsConfig().storedFields();
    }

    default Set<String> indexedFields() {
        return fieldsConfig().indexedFields();
    }

    default Set<String> rootAliasedFields() {
        return fieldsConfig().rootAliasedFields();
    }

    default Map<String, Integer> prefixSubstringFilterFields() {
        return fieldsConfig().prefixSubstringFilterFields();
    }

    /**
     * Calculates list of fields from alias leaf to root one (possible stored).
     * Example: need to find name of stored field which have current field as index_alias.
     * @param field - field name
     * @return list of ancestors of alias field
     */
    default List<FieldConfig> aliasChain(final String field) {
        return fieldsConfig().aliasReverseChain().get(field);
    }

    default boolean isIgnored(final String field) {
        return fieldsConfig().ignoredFields().contains(field);
    }

    default Set<String> yandexCodecBloomSet() {
        return fieldsConfig().bloomSet();
    }

    boolean orderIndependentUpdate();
}
