package ru.yandex.msearch.fieldscache;

import java.io.IOException;

import java.text.ParseException;

import org.apache.lucene.index.IndexReader;

import ru.yandex.msearch.FieldConfig;
import ru.yandex.msearch.collector.YaField;

public abstract class AbstractFieldCache implements FieldCache {
    private final FieldConfig fieldConfig;
    private int refs = 0;

    public AbstractFieldCache(final FieldConfig fieldConfig) {
        this.fieldConfig = fieldConfig;
    }

    @Override
    public synchronized void incRef() {
        refs++;
    }

    @Override
    public synchronized void decRef() {
        refs--;
    }

    @Override
    public synchronized int refs() {
        return refs;
    }

    @Override
    public String fieldname() {
        if (fieldConfig.cacheAlias() != null) {
            return fieldConfig.cacheAlias();
        }
        return fieldConfig.field();
    }

    @Override
    public String aliasname() {
        return fieldConfig.field();
    }

    @Override
    public FieldConfig fieldConfig() {
        return fieldConfig;
    }
}
