package ru.yandex.msearch.fieldscache;

import java.io.Closeable;
import java.io.IOException;

public interface CacheOutput {
    void newDoc(final int docId);

    void shareDoc(final int docId);

    void writeByte(final byte value) throws IOException;

    void writeInt(final int value) throws IOException;

    void writeVInt(final int value) throws IOException;

    void writeLong(final long value) throws IOException;

    void writeVLong(final long value) throws IOException;

    void write(final byte[] in, final int offset, final int length)
        throws IOException;

    void commit() throws IOException;

    void rollback() throws IOException;

    void finish() throws IOException;
}
