package ru.yandex.msearch.fieldscache;

import java.io.IOException;

import java.text.ParseException;

import org.apache.lucene.index.IndexReader;

import ru.yandex.msearch.FieldConfig;
import ru.yandex.msearch.collector.YaField;

public interface FieldCache {

    public enum Type {
        NO_CACHE {
            public FieldCache createCache(
                final IndexReader reader,
                final String field,
                final String alias,
                final FieldConfig fc)
                throws IOException
            {
                return null;
            }
        },
        RAW {
            public FieldCache createCache(
                final IndexReader reader,
                final String field,
                final String alias,
                final FieldConfig fc)
                throws IOException
            {
                return new RawFieldCache(
                    fc,
                    field,
                    alias,
                    reader.toString(),
                    reader.maxDoc());
            }
        };

        public abstract FieldCache createCache(
            final IndexReader reader,
            final String field,
            final String alias,
            final FieldConfig fc)
            throws IOException;
    }

    void incRef();

    void decRef();

    int refs();

    void free();

    CacheOutput writer() throws IOException;

    CacheOutput reopenWriter() throws IOException;

    CacheInput reader() throws IOException;

    String fieldname();

    String aliasname();

    FieldConfig fieldConfig();
}
