package ru.yandex.msearch.index;

import java.io.IOException;
import java.nio.charset.Charset;
import java.text.ParseException;

import ru.yandex.msearch.DatabaseManager;
import ru.yandex.msearch.HttpIndexerServer;
import ru.yandex.msearch.JsonBatchDeleteMessage;
import ru.yandex.msearch.MessageContext;
import ru.yandex.msearch.MessageQueueId;
import ru.yandex.msearch.QueueShard;
import ru.yandex.msearch.config.DatabaseConfig;
import ru.yandex.msearch.util.SumLimiter;

public class DeleteByPrimaryKeyHandler extends BaseIndexHandler {
    public DeleteByPrimaryKeyHandler(
        final DatabaseManager dbManager,
        final SumLimiter sumLimiter,
        final HttpIndexerServer server)
    {
        super(dbManager, sumLimiter, server);
    }

    @Override
    protected JsonBatchDeleteMessage parse(
        final MessageContext context,
        final byte[] dump,
        final Charset charset,
        final int priority,
        final QueueShard shard,
        final MessageQueueId queueId,
        final DatabaseConfig config,
        final boolean journalable,
        final boolean orderIndependentUpdate)
        throws IOException, ParseException
    {
        return new JsonBatchDeleteMessage(
            context,
            dump,
            charset,
            priority,
            shard,
            queueId,
            config,
            journalable,
            orderIndependentUpdate);
    }

    @Override
    public String toString() {
        return "https://wiki.yandex-team.ru/ps/Documentation/Lucene/"
            + "IndexHandlers#/delete";
    }
}
