package ru.yandex.msearch.indexprocessor;

import java.io.IOException;
import java.text.ParseException;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.IndexSearcher;
import ru.yandex.msearch.AbstractPart;
import ru.yandex.msearch.AnalyzerProvider;
import ru.yandex.msearch.HTMLDocument;

import ru.yandex.msearch.PrimaryKeyPartBase;
import ru.yandex.search.json.fieldfunction.ConditionsAccessor;

public interface IndexDocProcessor {
    void init(final AnalyzerProvider analyzerProvider) throws IOException, ParseException;

    void process(
        final PrimaryKeyPartBase part,
        final IndexSearcher indexSearcher,
        final ConditionsAccessor condAccessor,
        final HTMLDocument document)
        throws IOException, ParseException;
}
