package ru.yandex.msearch.indexprocessor;

import java.io.IOException;
import java.util.logging.Logger;

import ru.yandex.msearch.Config;
import ru.yandex.msearch.config.DatabaseConfig;
import ru.yandex.search.json.dp.IndexDocProcessorConfig;
import ru.yandex.search.json.dp.IndexDocProcessorType;
import ru.yandex.search.json.dp.join.JoinDocProcessorConfig;

public enum IndexDocProcessorFactory {
    INTSANCE;


    public IndexDocProcessor create(
        final IndexDocProcessorConfig docPprocConfig,
        final DatabaseConfig config,
        final Logger logger)
        throws IOException
    {
        if (docPprocConfig == null) {
            return null;
        }

        if (docPprocConfig.type() == IndexDocProcessorType.PKJOIN) {
            JoinDocProcessorConfig joinConf =
                (JoinDocProcessorConfig) docPprocConfig;
            return new PrimaryKeyJoinDocProcessor(joinConf, config, logger);
        }

        throw new IOException(
            "IndexDocProcessor not found for " + docPprocConfig.type());
    }
}
