package ru.yandex.msearch.knn;

import java.util.Comparator;

import ru.yandex.msearch.collector.YaField;

public class YaFieldHnswUtils {
    private enum DistComparator implements Comparator<Float> {
        INSTANCE;

        @Override
        public int compare(Float o1, Float o2) {
            return ((Comparator<Float>) Comparator.reverseOrder()).compare(o1, o2);
        }
    }

    public static class YaFieldItem implements Item<Integer, YaField.ByteArrayYaField> {
        private final YaField.ByteArrayYaField byteArray;
        private final int id;

        public YaFieldItem(int id, YaField.ByteArrayYaField arr) {
            this.id = id;
            this.byteArray = arr;
        }

        @Override
        public Integer id() {
            return id;
        }

        @Override
        public YaField.ByteArrayYaField vector() {
            return byteArray;
        }

        @Override
        public int dimensions() {
            return (int) byteArray.sizeInBytes();
        }
    }
}
