package ru.yandex.msearch.knn.util.disk;

import com.github.jelmerk.knn.DistanceFunction;

public enum DiskDistance implements DistanceFunction<byte[], Integer> {
    INSTANCE;

    @Override
    public Integer distance(final byte[] lhs, final byte[] rhs) {
        if (lhs.length != rhs.length) {
            throw new IllegalArgumentException(
                    "Expected hnsw vectors to have same dimensionality, found " + lhs.length + " and " + rhs.length);
        }
        int result = 0;
        for (int j = 0; j < lhs.length; j++) {
            result += ((int) lhs[j]) * rhs[j];
        }
        return result;
    }
}