package ru.yandex.msearch.knn.util.disk;

import ru.yandex.msearch.knn.hnsw.HnswIndex;

public final class DiskHnswIndex extends HnswIndex<String, byte[], DiskItem, Integer> {
    public DiskHnswIndex(RefinedBuilder<String, byte[], DiskItem, Integer> builder) {
        super(builder);
    }

    public DiskHnswIndex(HnswIndex<String, byte[], DiskItem, Integer> hnsw) {
        super(hnsw);
    }

    // safe add
    @Override
    public boolean add(DiskItem item) {
        if (item.dimensions() != getDimensions()) {
            return false;
        }
        return super.add(item);
    }
}