package ru.yandex.msearch.knn.util.disk;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import ru.yandex.msearch.collector.FieldToIndex;
import ru.yandex.msearch.collector.SortedCollector;
import ru.yandex.msearch.collector.YaField;
import ru.yandex.msearch.knn.Item;

public class DiskItem implements Item<String, byte[]> {
    private final Map<String, YaField> fields = new HashMap<>();
    private final String id;
    private final byte[] vector;

    public DiskItem(
            String id,
            byte[] vector)
    {
        this.id = id;
        this.vector = vector;
    }

    public DiskItem(
            String id,
            byte[] vector,
            Set<String> fieldNames,
            SortedCollector.YaDoc3Delayed doc,
            FieldToIndex fieldToIndex
    ) {
        this(id, vector);
        for (String fieldName: fieldNames) {
            int index = fieldToIndex.indexFor(fieldName);
            YaField field = doc.getField(index);
            fields.put(fieldName, field);
        }
    }

    @Override
    public String id() {
        return id;
    }

    @Override
    public byte[] vector() {
        return vector;
    }

    @Override
    public int dimensions() {
        return vector.length;
    }

    public Map<String, YaField> getFields() {
        return fields;
    }
}