package ru.yandex.msearch.knn.util.disk;

import java.io.IOException;
import java.util.List;
import java.util.function.Function;

import org.apache.lucene.index.IndexReader;

import ru.yandex.msearch.collector.SortedCollector;
import ru.yandex.msearch.collector.YaDocFieldVisitor;
import ru.yandex.msearch.collector.YaField;
import ru.yandex.msearch.fieldscache.CacheInput;

public final class DocLoader implements Function<SortedCollector.YaDoc3Delayed, Void> {
    private final YaDocFieldVisitor step1Visitor;
    private final IndexReader reader;
    private final List<CacheInput> caches;

    public DocLoader(
            YaDocFieldVisitor visitor1,
            IndexReader reader,
            List<CacheInput> caches)
    {
        this.step1Visitor = visitor1;
        this.reader = reader;
        this.caches = caches;
    }

    @Override
    public Void apply(SortedCollector.YaDoc3Delayed doc) {
        boolean filledFromCache = false;
        boolean useCache = caches != null;

        if (useCache) {
            boolean success = true;
            for (CacheInput oneFieldCache : caches) {
                YaField cachedField = null;
                try {
                    if (oneFieldCache.seek(doc.docId)) {
                        cachedField = oneFieldCache.field();
                    } else {
                        success = false;
                        break;
                    }
                } catch (IOException e) {
                    success = false;
                    break;
                }
                doc.setField(
                        oneFieldCache.fieldname(),
                        cachedField);
            }
            if (success) {
                filledFromCache = true;
            }
        }

        if (!filledFromCache) {
            step1Visitor.doc(doc);
            try {
                reader.readDocument(doc.docId, step1Visitor);
            } catch (IOException e) {
                return null;
            }
        }
        return null;
    }
}
