package ru.yandex.msearch.knn.util.disk;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import org.joda.time.DateTime;

import ru.yandex.search.prefix.Prefix;


public final class HnswCache extends LinkedHashMap<Prefix, HnswCache.CachedHnsw> {
    private static final int MAX_CAPACITY = 100;
    private static final long INVALIDATE_AFTER = TimeUnit.DAYS.toMillis(1);

    @Override
    protected boolean removeEldestEntry(
            Map.Entry<Prefix, HnswCache.CachedHnsw> eldest) {
        return size() > MAX_CAPACITY;
    }

    public void put(Prefix key, DiskHnswIndex index) {
        this.put(key, new CachedHnsw(index));
    }

    public DiskHnswIndex get(Prefix key) {
        CachedHnsw cached = super.get(key);
        if (cached == null) {
            return null;
        }
        DiskHnswIndex index = cached.hnsw();
        if (index == null) {
            this.remove(key);
        }
        return index;
    }
    
    public static class CachedHnsw {
        public final DiskHnswIndex index;
        public final DateTime timestamp;

        public CachedHnsw(DiskHnswIndex index) {
            this.index = index;
            this.timestamp = DateTime.now();
        }

        public DiskHnswIndex hnsw() {
            DateTime now = DateTime.now();
            if (timestamp.plus(INVALIDATE_AFTER).compareTo(now) < 0) {
                return null;
            }
            return index;
        }
    }
}