package ru.yandex.msearch.parallel;

import java.util.Vector;
import java.io.IOException;

import ru.yandex.msearch.Index;
import ru.yandex.search.prefix.PrefixParser;

public class ParallelExec {
    private Vector<ParallelWorker> threads = new Vector<ParallelWorker>();
    private Vector<ParallelWorker> threadsInWork = new Vector<ParallelWorker>();
    int threadsNr;
    private boolean abort = false;
    private final Index index;

    public ParallelExec(final Index index, int threadsNr, PrefixParser prefixParser) {
        this.threadsNr = threadsNr;
        this.index = index;
        for (int i = 0; i < threadsNr; i++) {
            ParallelWorker w;
            w = new ParallelWorker(index, this, prefixParser);
            threads.add(w);
            (new Thread(w, "ParallelExecWorker")).start();
        }
    }


    public void addWork(ParaWork work, Object workObj) throws IOException {
		if (abort) {
			return;
		}
        ParallelWorker w = null;

        while (w == null) {
            synchronized (threads) {
				if (abort) {
					return;
				}
                if (threads.size() == 0) {
                    try {
                        threads.wait(1000);
                    } catch (InterruptedException e) {
                        continue;
                    }
                } else {
                    w = threads.get(0);
                    threads.remove(0);
                    threadsInWork.add(w);
                }
            }
        }
		if (abort) {
			freeWorker(w);
		} else {
			w.setWork(work, workObj);
		}
    }

    public void freeWorker(ParallelWorker w) {
        synchronized (threads) {
            threads.add(w);
            threadsInWork.remove(w);
            threads.notify();
        }
    }

    public void stop() {
        int freeThreads = 0;
        System.err.println("ParallelExec: waiting for threads to finish work");
        while (freeThreads < threadsNr) {
            synchronized (threads) {
                freeThreads = threads.size();
//		System.err.println( "ParallelExec: waiting for threads to finish work: " + freeThreads );
                if (freeThreads < threadsNr) {
                    try {
                        threads.wait(1000);
                    } catch (InterruptedException e) {
                        continue;
                    }
                }
            }
        }
        System.err.println("ParallelExec: all threads have finished their works");
        synchronized (threads) {
            for (int i = 0; i < threadsNr; i++) {
                ParallelWorker w;
                w = threads.get(i);
                w.stop();
            }
        }
        System.err.println("ParallelExec: stoped all threads");
    }

    public void abort() {
        synchronized (threads) {
            abort = true;
            for (int i = 0; i < threadsInWork.size(); i++) {
                threadsInWork.get(i).abort();
            }
            for (int i = 0; i < threads.size(); i++) {
                threads.get(i).abort();
            }
            threads.notify();
        }
        stop();
    }
}

