package ru.yandex.msearch.parallel;

import ru.yandex.msearch.Index;
import ru.yandex.msearch.Shard;
import ru.yandex.msearch.collector.DocCollector;
import ru.yandex.msearch.HTTPWorker;

import org.apache.lucene.search.Query;

import ru.yandex.search.prefix.PrefixParser;

class ParallelWorker implements Runnable {
    private final Object lock = new Object();
    private final ParallelExec parent;
    private final PrefixParser prefixParser;
    private Object workObj = null;
    private ParaWork work;
	private final Index index;
    volatile boolean exit = false;

    public ParallelWorker(final Index index, ParallelExec parent, PrefixParser prefixParser) {
        this.parent = parent;
        this.index = index;
        this.prefixParser = prefixParser;
        workObj = null;
        work = null;
    }

    public void run() {
        while (!exit) {
            synchronized (lock) {
                if (work == null) {
                    try {
                        lock.wait();
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
					if (exit) {
						break;
					}
                }
            }

            if (work != null) {
                try {
                    if (work.cmd.startsWith("expunge")) {
                        Shard shard = (Shard) workObj;
                        Integer version = (Integer) work.params.get("version");
                        shard.expunge((Boolean) work.params.get("expungeAll"), version, 0, false);
                    } else if (work.cmd.startsWith("optimize")) {
                        int optimize = (Integer) work.params.get("num");
                        Shard shard = (Shard) workObj;
                        System.err.println("Running work: optimize=" + optimize + " at shard: " + shard.shardNo);
                        shard.optimize(optimize);
                    } else if (work.cmd.startsWith("closeShard")) {
                        Shard shard = (Shard) workObj;
                        shard.close();
                    } else if (work.cmd.startsWith("sharedSearch")) {
                        HTTPWorker worker = (HTTPWorker) workObj;
                        worker.singleSearch(index, prefixParser.parse(work.params.get("user")), (Query) work.params.get(
                        	"query"), (DocCollector) work.params.get("collector"));
                    } else if (work.cmd.equals("general")) {
                        work.exec();
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
                workObj = null;
                work = null;
                parent.freeWorker(this);
            }
        }
    }

    public void setWork(ParaWork work, Object workObj) {
        this.work = work;
        this.workObj = workObj;
        synchronized (lock) {
            lock.notify();
        }
    }

    public void stop() {
        synchronized (lock) {
            exit = true;
            lock.notify();
        }
    }

    public void abort() {
        synchronized (lock) {
            if (work != null && work.cmd.equals("general")) {
                work.abort();
                exit = true;
            }
        }
    }
}

