package ru.yandex.msearch.printkeys;

import java.io.Closeable;
import java.io.IOException;

public interface PrintKeysWriter extends Closeable {
    void startTerm(String term) throws IOException;

    void endTerm() throws IOException;

    void termFreq(int freq) throws IOException;

    void termFreq(int freq, int totalFreq) throws IOException;

    void startDocs() throws IOException;

    void endDocs() throws IOException;

    void startDoc(int docId) throws IOException;

    void endDoc() throws IOException;

    void startFields() throws IOException;

    void endFields() throws IOException;

    void field(String value) throws IOException;

    void startPositions() throws IOException;

    void endPositions() throws IOException;

    void pos(int pos) throws IOException;
}
