package ru.yandex.msearch.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

import ru.yandex.io.DecodingInputStream;

public abstract class BlockDecompressingInputStream
    extends DecodingInputStream
{
    private static final int BUFFER_SIZE = 4096;

    private byte[] readBuffer = new byte[BUFFER_SIZE];

    public BlockDecompressingInputStream(final InputStream in) {
        super(in);
    }

    protected abstract void decompress(
        final byte[] src,
        final byte[] dst,
        final int compressedSize,
        final int decompressedSize)
        throws IOException;

    @Override
    protected void fillBuffer() throws IOException {
        int compressed = readVInt();
        if (compressed == -1) {
//            System.err.println("BlockDecompressingInputStream.java EOF");
            buflen = 0;
            pos = 0;
            return;
        }
        int decompressed = readVInt();
//        System.err.println("Reading: " + compressed + " / " + decompressed);

        if (readBuffer.length < compressed) {
            readBuffer = new byte[Math.max(readBuffer.length << 1, compressed)];
        }
        readFully(compressed);
        ensureCapacity(decompressed);
        decompress(readBuffer, buf, compressed, decompressed);
        buflen = decompressed;
        pos = 0;
    }

    private byte readByte() throws IOException {
        int b = in.read();
        if (b == -1) {
            throw new EOFException();
        }
        return (byte) b;
    }

    private int readVInt() throws IOException {
        int firstByte = in.read();
        if (firstByte == -1) {
            return -1;
        }
        byte b = (byte) firstByte;
        int i = b & 0x7F;
        for (int shift = 7; (b & 0x80) != 0; shift += 7) {
            b = readByte();
            i |= (b & 0x7F) << shift;
        }
        return i;
    }

    private void readFully(final int size) throws IOException {
        int len = size;
        int n = 0;
        while (n < len) {
            int count = in.read(readBuffer, n, len - n);
            if (count < 0) {
                throw new EOFException();
            }
            n += count;
        }
    }
}
