package ru.yandex.msearch.util;

import java.util.List;

import ru.yandex.concurrent.TimeFrameQueue;

import ru.yandex.stater.Stater;
import ru.yandex.stater.StatsConsumer;

public class IOStater
    extends TimeFrameQueue<ImmutableIOStats>
    implements Stater
{
    private final String prefix;

    public IOStater(final long metricsTimeFrame, final String prefix) {
        super(metricsTimeFrame);
        this.prefix = prefix;
    }

    @Override
    public <E extends Exception> void stats(
        final StatsConsumer<? extends E> statsConsumer)
        throws E
    {
        int count = 0;
        int reads = 0;
        int ssdReads = 0;
        int unpackReads = 0;
        long totalBytesRead = 0L;
        long totalSSDBytesRead = 0L;
        long totalBytesUnpacked = 0L;
        long totalReadTime = 0L;
        long totalSSDReadTime = 0L;
        long totalUnpackReadTime = 0L;
        for (ImmutableIOStats stat: this) {
            ++count;
            reads += stat.reads();
            ssdReads += stat.ssdReads();
            unpackReads += stat.unpackReads();
            totalBytesRead += stat.totalBytesRead();
            totalSSDBytesRead += stat.totalSSDBytesRead();
            totalBytesUnpacked += stat.totalBytesUnpacked();
            totalReadTime += stat.totalReadTime();
            totalSSDReadTime += stat.totalSSDReadTime();
            totalUnpackReadTime += stat.totalUnpackReadTime();
        }
        statsConsumer.stat(prefix + "-iostats-count_ammm", count);
        statsConsumer.stat(prefix + "-iostats-reads_ammm", reads);
        statsConsumer.stat(prefix + "-iostats-ssd-reads_ammm", ssdReads);
        statsConsumer.stat(prefix + "-iostats-unpack-reads_ammm", unpackReads);
        statsConsumer.stat(
            prefix + "-iostats-bytes-read_ammm",
            totalBytesRead);
        statsConsumer.stat(
            prefix + "-iostats-ssd-bytes-read_ammm",
            totalSSDBytesRead);
        statsConsumer.stat(
            prefix + "-iostats-unpack-bytes-read_ammm",
            totalBytesUnpacked);
        statsConsumer.stat(prefix + "-iostats-read-time_ammm", totalReadTime);
        statsConsumer.stat(
            prefix + "-iostats-ssd-read-time_ammm",
            totalSSDReadTime);
        statsConsumer.stat(
            prefix + "-iostats-unpack-read-time_ammm",
            totalUnpackReadTime);
    }
}

