package ru.yandex.msearch.util;

public class ImmutableIOStats {
    private final int reads;
    private final int ssdReads;
    private final int unpackReads;
    private final long totalBytesRead;
    private final long totalSSDBytesRead;
    private final long totalBytesUnpacked;
    private final long totalReadTime;
    private final long totalSSDReadTime;
    private final long totalUnpackReadTime;

    public ImmutableIOStats(final IOStats stats) {
        reads = stats.reads();
        ssdReads = stats.ssdReads();
        unpackReads = stats.unpackReads();
        totalBytesRead = stats.totalBytesRead();
        totalSSDBytesRead = stats.totalSSDBytesRead();
        totalBytesUnpacked = stats.totalBytesUnpacked();
        totalReadTime = stats.totalReadTime();
        totalSSDReadTime = stats.totalSSDReadTime();
        totalUnpackReadTime = stats.totalUnpackReadTime();
    }

    public int reads() {
        return reads;
    }

    public int ssdReads() {
        return ssdReads;
    }

    public int unpackReads() {
        return unpackReads;
    }

    public long totalBytesRead() {
        return totalBytesRead;
    }

    public long totalSSDBytesRead() {
        return totalSSDBytesRead;
    }

    public long totalBytesUnpacked() {
        return totalBytesUnpacked;
    }

    public long totalReadTime() {
        return totalReadTime;
    }

    public long totalSSDReadTime() {
        return totalSSDReadTime;
    }

    public long totalUnpackReadTime() {
        return totalUnpackReadTime;
    }
}

