package ru.yandex.msearch.util;

import org.apache.lucene.util.Bits;

public class InvertBits implements Bits {
    private final Bits bits;

    public InvertBits(final Bits bits) {
        this.bits = bits;
    }

    @Override
    public boolean get(final int index) {
        return !bits.get(index);
    }

    @Override
    public int length() {
        return bits.length();
    }

    @Override
    public int count() {
        return bits.length() - bits.count();
    }
}

