package ru.yandex.msearch.util;

import org.apache.lucene.util.Bits;

public class OrNotBits implements Bits {
    private final Bits lhs;
    private final Bits rhs;

    public OrNotBits(final Bits lhs, final Bits rhs) {
        this.lhs = lhs;
        this.rhs = rhs;
    }

    @Override
    public boolean get(final int index) {
        return lhs.get(index) || !rhs.get(index);
    }

    @Override
    public int length() {
        return Math.max(lhs.length(), rhs.length());
    }

    @Override
    public int count() {
        int length = length();
        int count = 0;
        for (int i = 0; i < length; i++) {
            if (get(i)) {
                count++;
            }
        }
        return count;
    }
}

