package ru.yandex.msearch.util;

import java.io.Closeable;

import org.apache.lucene.util.packed.PackedInts;

import ru.yandex.msearch.util.JavaAllocator;

public class PackedIntsHashMap implements Closeable {
    private static final boolean debug = false;
//    private static final boolean debug = true;
    private static final int HASH_PRIME = 31;
    private static final int INITIAL_SIZE = 16;
    private static final int INT_SIZE = 4;
    private static final int HASH_OFFSET = 0;
    private static final int KEY_OFFSET = 4;
    private static final int KEY_DATA_OFFSET = 8;
    private static final int EMPTY = -1;

    private final PackedInts.Mutable keys;
    private final PackedInts.Mutable values;
    private final int size;
    private final int empty;
    private volatile boolean closed = false;

    public PackedIntsHashMap(
        final int size,
        final int maxKey,
        final long maxValue,
        final JavaAllocator allocator)
    {
//        this.size = size + (size);
        this.size = Math.max(size + (size / 3) + 1 , 1);
//        bitSet = new NativeFixedBitSet(maxKey, allocator);
        values = PackedInts.getMutable(
            this.size,
            PackedInts.bitsRequired(maxValue),
            allocator);
        keys = PackedInts.getMutable(
            this.size,
            PackedInts.bitsRequired(maxKey + 1),
            allocator);
        for (int i = 0; i < this.size; i++) {
            keys.set(i, -1);
        }
        empty = (int) keys.get(0);
//        System.err.println("Empty: " + Integer.toHexString(empty));
    }

    private static final int hash(int h) {
//        h += (h <<  15) ^ 0xffffcd7d;
//        h ^= (h >>> 10);
//        h += (h <<   3);
//        h ^= (h >>>  6);
//        h += (h <<   2) + (h << 14);
//        return h ^ (h >>> 16);
        h = ((h >>> 16) ^ h) * 0x45d9f3b;
        h = ((h >>> 16) ^ h) * 0x45d9f3b;
        h = (h >>> 16) ^ h;
        return h;
     }

    private final int posForHash(final int hashCode, final int size) {
        return Math.abs(hashCode % size);
    }

    public void put(
        final int key,
        final long value)
    {
        final int hash = hash(key);
        int hashPos = posForHash(hash, size);
        int scans = 0;
        while (true) {
            int exist = (int) keys.get(hashPos);
            if (exist == empty) {
                keys.set(hashPos, key);
                values.set(hashPos, value);
                break;
            } else if (exist == key) {
                throw new IllegalStateException("Value for key: "
                    + key + " is already set");
            }
            hashPos = posForHash(hashPos + 1, size);
            scans++;
            if (scans == size) {
                throw new IllegalStateException("HashTable full: "
                    + "key=" + key + ", size=" + size
                    + ", lastExists=" + exist);
            }
        }
//        bitSet.set(key);
    }

    public long get(final int key) {
//        long stamp = readLock();
//        try {
            if (closed) {
                return -1;
            }
//            if (!bitSet.get(key)) {
//                return -1;
//            }
            final int hash = hash(key);
            int hashPos = posForHash(hash, size);
            int scans = 0;
            while (true) {
                int exist = (int) keys.get(hashPos);
                if (exist == empty) {
                    return -1L;
                } else if (exist == key) {
                    return values.get(hashPos);
                }
                hashPos = posForHash(hashPos + 1, size);
                scans++;
                if (scans == size) {
                    throw new IllegalStateException("HashTable scans overrun");
                }
            }
//        } finally {
//            unlockRead(stamp);
//        }
    }

    @Override
    public void close() {
//        long stamp = writeLock();
//        try {
            closed = true;
            values.close();
            keys.close();
//            bitSet.close();
//        } finally {
//            unlockWrite(stamp);
//        }
    }

    public static void main(final String[] args) {
        int maxDoc = 10000000;
        int size = 1024 * 768;
        int step = maxDoc / size;
        for (int t = 0; t < 100; t++) {
            long start = System.currentTimeMillis();
            PackedIntsHashMap map = new PackedIntsHashMap(
                size,
                maxDoc,
                (long) (maxDoc << 1),
                JavaAllocator.get("QWE"));
            for (int i = 0, c = 0; i < maxDoc && c < size; i += step, c++) {
                map.put(i, i << 1);
            }
            System.err.println("PIHM Write time: "
                + (System.currentTimeMillis() - start));
            start = System.currentTimeMillis();
            for (int i = 0, c = 0; i < maxDoc && c < size; i += step, c++) {
                long expect = i << 1;
                if (map.get(i) != expect) {
                    throw new RuntimeException("Values missmatch for key: "
                        + i);
                }
            }
            System.err.println("PIHM Read time: "
                + (System.currentTimeMillis() - start));
            start = System.currentTimeMillis();
            for (int i = 1, c = 0; i < maxDoc && c < size; i += step, c++) {
                if (map.get(i) != -1) {
                    throw new RuntimeException("Values missmatch for key: "
                        + i);
                }
            }
            System.err.println("PIHM Miss Read time: "
                + (System.currentTimeMillis() - start));
            map.close();
            start = System.currentTimeMillis();
            PackedInts.Mutable test = PackedInts.getMutable(
                maxDoc,
                PackedInts.bitsRequired(maxDoc << 1),
                JavaAllocator.get("QWE2"));
            for (int i = 0, c = 0; i < maxDoc && c < size; i += step, c++) {
                test.set(i, i << 1);
            }
            System.err.println("PI Write time: "
                + (System.currentTimeMillis() - start));
            start = System.currentTimeMillis();
            for (int i = 0, c = 0; i < maxDoc && c < size; i += step, c++) {
                long expect = i << 1;
                if (test.get(i) != expect) {
                    throw new RuntimeException("Values missmatch for key: "
                        + i);
                }
            }
            System.err.println("PI Read time: "
                + (System.currentTimeMillis() - start));
            test.close();
        }
    }
}
