package ru.yandex.msearch.warmfunction;

import java.text.ParseException;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.parser.string.EnumParser;

public enum WarmFunctionFactory {
    INSTANCE;

    public static List<WarmFunction> parseFunctions(final String str)
        throws ParseException
    {
        String trimmed = str.trim();
        if (trimmed.length() == 0) {
            return null;
        }
        String[] funcs = str.split(";");
        List<WarmFunction> functions = new ArrayList<>(funcs.length);
        for (String function: funcs) {
            functions.add(parseFunction(function.trim()));
        }
        return functions;
    }

    private static WarmFunction parseFunction(final String str)
        throws ParseException
    {
        int openBrace = str.indexOf('(');
        final String name;
        final String[] args;
        if (openBrace != -1) {
            if (str.charAt(str.length() - 1) != ')') {
                parseError("Missing closing brace ')' at: " + str);
            }
            name = str.substring(0, openBrace);
            args = str.substring(
                openBrace + 1,
                str.length() - 1)
                    .trim().split(",");
        } else {
            name = str;
            args = new String[0];
        }
        try {
            return new EnumParser<>(WarmFunctionType.class)
                .apply(name)
                .create(args);
        } catch (RuntimeException e) {
            e.printStackTrace();
            parseError(
                "Failed to parse function: " + str);
            //should never reach this
            return null;
        }
    }

    private static void parseError(final String msg) throws ParseException {
        throw new ParseException(msg, 0);
    }
}
