package ru.yandex.queryParser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;

public class MultiFieldQueryParser extends QueryParser {
    private final QueryParserFactory factory;
    private final String[] fields;

    public MultiFieldQueryParser(final QueryParserFactory factory,
        final Analyzer analyzer, final String... fields)
    {
        super(factory.version(), null, analyzer);
        this.factory = factory;
        this.fields = fields;
    }

    private static boolean equals(final List<BooleanClause> lhs,
        final List<BooleanClause> rhs)
    {
        if (rhs.size() == lhs.size()) {
            Iterator<BooleanClause> li = lhs.iterator();
            Iterator<BooleanClause> ri = rhs.iterator();
            while (li.hasNext() && ri.hasNext()) {
                if (li.next().getOccur() != ri.next().getOccur()) {
                    return false;
                }
            }
            return li.hasNext() == ri.hasNext();
        } else {
            return false;
        }
    }

    private static boolean equals(final BooleanQuery lhs, final Query rhs) {
        if (rhs instanceof BooleanQuery) {
            BooleanQuery rq = (BooleanQuery) rhs;
            return lhs.isCoordDisabled() == rq.isCoordDisabled() &&
                equals(lhs.clauses(), rq.clauses());
        } else {
            return false;
        }
    }

    private static BooleanQuery doMerge(final List<BooleanQuery> queries) {
        BooleanQuery example = queries.get(0);
        BooleanQuery query = new BooleanQuery(example.isCoordDisabled());
        int len = example.getClauses().length;
        for (int i = 0; i < len; ++i) {
            BooleanQuery subQuery =
                new BooleanQuery(example.isCoordDisabled());
            for (BooleanQuery q: queries) {
                subQuery.add(q.getClauses()[i].getQuery(),
                    BooleanClause.Occur.SHOULD);
            }
            query.add(subQuery, example.getClauses()[i].getOccur());
        }
        return query;
    }

    public static Query merge(final List<Query> queries) {
        List<Query> qs = new ArrayList<>(queries.size());
        for (Query query: queries) {
            if (!(query == null || qs.contains(query)
                || (query instanceof BooleanQuery
                    && ((BooleanQuery) query).clauses().isEmpty())))
            {
                qs.add(query);
            }
        }
        if (qs.size() == 1) {
            return qs.get(0);
        } else {
            BooleanQuery query = new BooleanQuery(true);
            for (int i = 0; i < qs.size(); ++i) {
                Query q = qs.get(i);
                if (q instanceof BooleanQuery) {
                    BooleanQuery bq = (BooleanQuery) q;
                    List<BooleanQuery> mergeable = new ArrayList<>();
                    for (int j = qs.size() - 1; j > i; --j) {
                        if (equals(bq, qs.get(j))) {
                            mergeable.add((BooleanQuery) qs.remove(j));
                        }
                    }
                    if (!mergeable.isEmpty()) {
                        mergeable.add(bq);
                        q = doMerge(mergeable);
                    }
                }
                query.add(q, BooleanClause.Occur.SHOULD);
            }
            return query;
        }
    }

    @Override
    public Query parse(final String text) throws ParseException {
        List<Query> queries = new ArrayList<>(fields.length);
        for (String field: fields) {
            queries.add(factory.create(field, this).parse(text));
        }
        return merge(queries);
    }
}

